#ifndef __ARPHEADER_H_
#define __ARPHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _arp_header
{
  u_short hw_type;
  u_short prot_type;
  u_char hw_addr_size;
  u_char prot_addr_size;
  u_short op;
  u_char Src_a_hw[ETH_ALEN];
  u_char Src_a_ip[IP_ALEN];
  u_char Dst_a_hw[ETH_ALEN];
  u_char Dst_a_ip[IP_ALEN];
};
#pragma pack(pop)

#define ARP_HEADER_SIZE sizeof(_arp_header)
#define ARPHRD_ETHER 1
#define ARP_OP_REQUEST 1
#define ARP_OP_REPLY 2

class ARPHeader
{
public:
  ARPHeader(u_short _opcode, u_char *_srcMAC, u_char *_dstMAC, u_char *_srcIP, u_char *_dstIP);
  ARPHeader(const u_char *_data);
  void dump();
  void setMem(u_char *_data);
  const u_char *srcMAC() const;
  const u_char *dstMAC() const;
  const u_char *srcIP() const;
  const u_char *dstIP() const;
  u_short  opcode() const;

private:
  _arp_header data;
  void data2host(void);
  void data2network(void);
};

#endif 
